<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

class XenCentral_AdServer_Model_XenForo_Post extends XFCP_XenCentral_AdServer_Model_XenForo_Post
{
    public function preparePostJoinOptions(array $fetchOptions)
    {
        $joinOptions=parent::preparePostJoinOptions($fetchOptions);
        if(
            strpos($joinOptions['joinTables'], 'INNER JOIN xf_thread')===false
            AND !empty($fetchOptions['join'])
            AND ($fetchOptions['join'] & XenForo_Model_Post::FETCH_USER)
        ) {
            $joinOptions['joinTables'].='
            INNER JOIN xf_thread AS as_thread ON
            (as_thread.thread_id = post.thread_id)
            ';
            $joinOptions['selectFields'] .= ', as_thread.node_id';
        }
        return $joinOptions;
    }

}